/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.datasource.db;

import de.willuhn.datasource.db.AbstractDBObject;
import de.willuhn.datasource.db.DBIteratorImpl;
import de.willuhn.datasource.db.MyDriver;
import de.willuhn.datasource.db.ObjectMetaCache;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.datasource.rmi.DBObject;
import de.willuhn.datasource.rmi.DBService;
import de.willuhn.datasource.rmi.ResultSetExtractor;
import de.willuhn.logging.Logger;
import de.willuhn.util.ClassFinder;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DBServiceImpl
extends UnicastRemoteObject
implements DBService {
    private static final long serialVersionUID = 1L;
    private String jdbcDriver = null;
    private String jdbcUrl = null;
    private String jdbcUsername = null;
    private String jdbcPassword = null;
    private Map connections = null;
    private boolean started = false;
    private boolean startable = true;
    private ClassFinder finder = null;
    private ClassLoader loader = null;

    public DBServiceImpl() throws RemoteException {
        this(null, null, null, null);
    }

    public DBServiceImpl(String jdbcDriver, String jdbcURL) throws RemoteException {
        this(jdbcDriver, jdbcURL, null, null);
    }

    public DBServiceImpl(String jdbcDriver, String jdbcURL, String jdbcUsername, String jdbcPassword) throws RemoteException {
        Logger.debug((String)("using jdbc driver  : " + jdbcDriver));
        Logger.debug((String)("using jdbc url     : " + jdbcURL));
        Logger.debug((String)("using jdbc username: " + jdbcUsername));
        this.jdbcUrl = jdbcURL;
        this.jdbcDriver = jdbcDriver;
        this.jdbcUsername = jdbcUsername;
        this.jdbcPassword = jdbcPassword;
        this.connections = Collections.synchronizedMap(new HashMap());
    }

    protected Connection getConnection() throws RemoteException {
        String key = this.getClientIdentifier();
        Connection conn = (Connection)this.connections.get(key);
        if (conn != null) {
            try {
                this.checkConnection(conn);
            }
            catch (SQLException e) {
                Logger.info((String)("connection check failed, creating new connection. message: " + e.getMessage()));
                conn = null;
            }
        }
        if (conn == null) {
            conn = this.createConnection();
            try {
                conn.setAutoCommit(this.getAutoCommit());
                int trLevel = this.getTransactionIsolationLevel();
                if (trLevel > 0) {
                    Logger.info((String)("transaction isolation level: " + trLevel));
                    conn.setTransactionIsolation(trLevel);
                }
            }
            catch (SQLException e) {
                throw new RemoteException("autocommit=false failed or transaction isolation level not supported", e);
            }
            Logger.info((String)("created new connection for " + (key == null ? "<local>" : key)));
            this.connections.put(key, conn);
        }
        return conn;
    }

    private String getClientIdentifier() {
        try {
            return UnicastRemoteObject.getClientHost();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private Connection createConnection() throws RemoteException {
        Logger.info((String)"creating new connection");
        String url = this.getJdbcUrl();
        try {
            String username = this.getJdbcUsername();
            String password = this.getJdbcPassword();
            if (username != null && username.length() > 0 && password != null) {
                return DriverManager.getConnection(url, username, password);
            }
            return DriverManager.getConnection(url);
        }
        catch (SQLException e2) {
            throw new RemoteException("connection to database." + url + " failed", e2);
        }
    }

    private void closeConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            Logger.info((String)"commit connection");
            try {
                conn.commit();
            }
            catch (Exception e) {
                Logger.warn((String)"commit failed");
            }
            Logger.info((String)"closing connection");
            conn.close();
            Logger.info((String)"connection closed");
        }
        catch (Throwable t) {
            Logger.error((String)("error while closing connection. message: " + t.getMessage()));
        }
    }

    protected void checkConnection(Connection conn) throws SQLException {
    }

    protected void setClassFinder(ClassFinder finder) {
        this.finder = finder;
    }

    protected void setClassloader(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public synchronized boolean isStartable() throws RemoteException {
        return this.startable;
    }

    @Override
    public synchronized void start() throws RemoteException {
        block9: {
            if (this.isStarted()) {
                return;
            }
            if (!this.isStartable()) {
                throw new RemoteException("service restart not allowed");
            }
            Logger.info((String)"starting db service");
            try {
                Logger.info((String)("request from host: " + UnicastRemoteObject.getClientHost()));
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
            String driver = this.getJdbcDriver();
            try {
                if (this.loader != null) {
                    try {
                        DriverManager.registerDriver(new MyDriver(driver, this.loader));
                        break block9;
                    }
                    catch (Throwable t) {
                        throw new RemoteException("unable to load jdbc driver", t);
                    }
                }
                Class.forName(driver);
            }
            catch (ClassNotFoundException e2) {
                Logger.error((String)("unable to load jdbc driver " + driver), (Throwable)e2);
                throw new RemoteException("unable to load jdbc driver " + driver, e2);
            }
        }
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop(boolean restartAllowed) throws RemoteException {
        if (!this.started) {
            Logger.info((String)"service allready stopped");
            return;
        }
        String key2 = this.getClientIdentifier();
        if (key2 != null) {
            Logger.info((String)("disconnect client " + key2));
            this.closeConnection((Connection)this.connections.remove(key2));
            return;
        }
        try {
            this.startable = restartAllowed;
            Logger.info((String)"stopping db service");
            try {
                Logger.info((String)("stop request from host: " + DBServiceImpl.getClientHost()));
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
            Logger.debug((String)("db service: object cache matches: " + ObjectMetaCache.getStats() + " %"));
            int count = 0;
            Map map = this.connections;
            synchronized (map) {
                for (String key2 : this.connections.keySet()) {
                    this.closeConnection((Connection)this.connections.remove(key2));
                    ++count;
                }
            }
            Logger.info((String)("db service stopped [" + count + " connection(s) closed]"));
        }
        finally {
            this.started = false;
        }
    }

    private <T extends DBObject> T create(Class<? extends DBObject> c) throws Exception {
        Class clazz = c;
        if (this.finder != null) {
            Class[] found = this.finder.findImplementors(c);
            clazz = found[found.length - 1];
        }
        if (clazz.isInterface()) {
            throw new Exception("no classfinder defined: unable to find implementor for interface " + c.getName());
        }
        Constructor<? extends DBObject> ct = clazz.getConstructor(new Class[0]);
        ct.setAccessible(true);
        AbstractDBObject o = (AbstractDBObject)ct.newInstance(new Object[0]);
        o.setService(this);
        o.init();
        return (T)o;
    }

    @Override
    public <T extends DBObject> T createObject(Class<? extends DBObject> c, String identifier) throws RemoteException {
        this.checkStarted();
        try {
            Logger.debug((String)("try to create new DBObject. request from host: " + DBServiceImpl.getClientHost()));
        }
        catch (ServerNotActiveException serverNotActiveException) {
            // empty catch block
        }
        try {
            T o = this.create(c);
            o.load(identifier);
            return o;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            Logger.error((String)("unable to create object " + (c == null ? "unknown" : c.getName())), (Throwable)e);
            throw new RemoteException("unable to create object " + (c == null ? "unknown" : c.getName()), e);
        }
    }

    @Override
    public <T extends DBObject> DBIterator<T> createList(Class<? extends DBObject> c) throws RemoteException {
        this.checkStarted();
        try {
            Logger.debug((String)("try to create new DBIterator. request from host: " + DBServiceImpl.getClientHost()));
        }
        catch (ServerNotActiveException serverNotActiveException) {
            // empty catch block
        }
        try {
            T o = this.create(c);
            return new DBIteratorImpl<AbstractDBObject>((AbstractDBObject)o, this);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            Logger.error((String)("unable to create list for object " + c.getName()), (Throwable)e);
            throw new RemoteException("unable to create list for object " + c.getName(), e);
        }
    }

    @Override
    public Object execute(String sql, Object[] params, ResultSetExtractor extractor) throws RemoteException {
        this.checkStarted();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.getConnection().prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    Object o = params[i];
                    if (o == null) {
                        ps.setNull(i + 1, 0);
                        continue;
                    }
                    ps.setObject(i + 1, params[i]);
                }
            }
            rs = ps.executeQuery();
            Object i = extractor.extract(rs);
            return i;
        }
        catch (SQLException e) {
            Logger.error((String)"error while executing sql statement", (Throwable)e);
            throw new RemoteException("error while executing sql statement: " + e.getMessage(), e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {
                    Logger.error((String)"error while closing resultset", (Throwable)t);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t2) {
                    Logger.error((String)"error while closing statement", (Throwable)t2);
                }
            }
        }
    }

    private synchronized void checkStarted() throws RemoteException {
        if (!this.isStarted()) {
            throw new RemoteException("db service not started");
        }
    }

    @Override
    public synchronized boolean isStarted() throws RemoteException {
        return this.started;
    }

    @Override
    public String getName() throws RemoteException {
        return "database service";
    }

    protected String getJdbcDriver() throws RemoteException {
        return this.jdbcDriver;
    }

    protected String getJdbcUrl() throws RemoteException {
        return this.jdbcUrl;
    }

    protected String getJdbcUsername() throws RemoteException {
        return this.jdbcUsername;
    }

    protected String getJdbcPassword() throws RemoteException {
        return this.jdbcPassword;
    }

    protected int getTransactionIsolationLevel() throws RemoteException {
        return -1;
    }

    protected boolean getAutoCommit() throws RemoteException {
        return false;
    }

    protected boolean getInsertWithID() throws RemoteException {
        return true;
    }
}

